/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.client.particle.DMC;

import com.dfdyz.epicacg.client.particle.DMC.SpaceBrokenEndParticle;
import com.dfdyz.epicacg.client.render.EpicACGRenderType;
import com.dfdyz.epicacg.client.render.pipeline.PostEffectPipelines;
import com.dfdyz.epicacg.registry.MyModels;
import com.dfdyz.epicacg.utils.MathUtils;
import com.dfdyz.epicacg.utils.RenderUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SpaceBrokenParticle
extends Particle {
    final int layer;
    float yaw;

    public SpaceBrokenParticle(ClientLevel level, double x, double y, double z, float yaw, int lifetime, int layer) {
        super(level, x, y, z);
        this.f_107219_ = false;
        this.f_107225_ = lifetime;
        this.layer = layer;
        this.yaw = yaw;
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float pt) {
        if (!PostEffectPipelines.isActive()) {
            return;
        }
        if (this.layer == 0) {
            EpicACGRenderType.SpaceBroken1.callPipeline();
        } else {
            EpicACGRenderType.SpaceBroken2.callPipeline();
        }
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(this.f_107212_ - vec3.m_7096_());
        float f1 = (float)(this.f_107213_ - vec3.m_7098_() + (double)(this.layer == 0 ? 0.2f : 0.4f));
        float f2 = (float)(this.f_107214_ - vec3.m_7094_());
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        int light = 0xF000F0;
        float sss = this.layer == 0 ? 1.2f : 1.3f;
        Vector3f camNormal = new Vector3f((Vector3fc)camera.m_253058_());
        camNormal.normalize();
        float camYaw = camera.m_90590_() + (float)(this.layer == 0 ? 0 : 45);
        float camPitch = camera.m_90589_();
        camPitch = camPitch > 0.0f ? camPitch : -(camPitch /= 90.0f);
        Quaternionf rot = MathUtils.fromEuler(this.layer == 0 ? 0 : 120, (float)((double)((this.yaw + 30.0f) / 180.0f) * Math.PI) + (float)(this.layer == 0 ? 0 : 75), 0.0f);
        rot.mul((Quaternionfc)(this.layer == 0 ? MathUtils.Quat_One : MathUtils.fromEuler(45.0f, 90.0f, 45.0f)));
        for (int index = 0; index < MyModels.SpaceBrokenModel.Face.size(); ++index) {
            OBJ_JSON.Triangle triangle = MyModels.SpaceBrokenModel.Face.get(index);
            Vector3f vertex1 = MyModels.SpaceBrokenModel.Positions.get(triangle.x - 1).toBugJumpFormat();
            Vector3f vertex2 = MyModels.SpaceBrokenModel.Positions.get(triangle.y - 1).toBugJumpFormat();
            Vector3f vertex3 = MyModels.SpaceBrokenModel.Positions.get(triangle.z - 1).toBugJumpFormat();
            vertex1.rotate((Quaternionfc)rot);
            vertex1.mul(sss);
            vertex2.mul(sss);
            vertex3.mul(sss);
            vertex1.add(f, f1, f2);
            vertex2.add(f, f1, f2);
            vertex3.add(f, f1, f2);
            Vector3f col_normal = triangle.Normal.toBugJumpFormat();
            col_normal.rotate((Quaternionfc)rot);
            col_normal.normalize();
            float offset = Math.abs(camNormal.dot((Vector3fc)col_normal));
            float ya = (camYaw % 360.0f + 360.0f + 180.0f * offset) % 360.0f / 360.0f;
            ya = (double)ya < 0.5 ? ya * 2.0f : -ya * 2.0f + 2.0f;
            buffer.m_5483_((double)vertex1.x(), (double)vertex1.y(), (double)vertex1.z()).m_85950_(offset, ya, camPitch, 1.0f).m_7421_(u1, v0).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertex2.x(), (double)vertex2.y(), (double)vertex2.z()).m_85950_(offset, ya, camPitch, 1.0f).m_7421_(u0, v0).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertex3.x(), (double)vertex3.y(), (double)vertex3.z()).m_85950_(offset, ya, camPitch, 1.0f).m_7421_(u0, v1).m_85969_(light).m_5752_();
        }
    }

    public boolean shouldCull() {
        return false;
    }

    public ParticleRenderType m_7556_() {
        return this.layer == 0 ? EpicACGRenderType.SpaceBroken1 : EpicACGRenderType.SpaceBroken2;
    }

    public void m_107274_() {
        super.m_107274_();
        float lastAng = Mth.m_216267_((RandomSource)this.f_107223_, (float)0.0f, (float)360.0f);
        for (int i = 0; i < 12; ++i) {
            lastAng = Mth.m_216267_((RandomSource)this.f_107223_, (float)(120.0f + lastAng - 45.0f), (float)(120.0f + lastAng + 45.0f));
            float r = Mth.m_216267_((RandomSource)this.f_107223_, (float)0.0f, (float)5.0f);
            double sx = Math.sin((double)(lastAng / 180.0f) * Math.PI) * (double)r;
            double sy = Mth.m_216267_((RandomSource)this.f_107223_, (float)1.0f, (float)6.0f);
            double sz = Math.cos((double)(lastAng / 180.0f) * Math.PI) * (double)r;
            SpaceBrokenEndParticle spaceBrokenEndParticle = new SpaceBrokenEndParticle(Minecraft.m_91087_().f_91073_, sx + this.f_107212_, sy + this.f_107213_ + 1.0, sz + this.f_107214_, 30);
            RenderUtils.AddParticle(Minecraft.m_91087_().f_91073_, spaceBrokenEndParticle);
        }
    }

    public static class OBJ_JSON {
        public List<vec3f> Positions = new ArrayList<vec3f>();
        public List<Triangle> Face = new ArrayList<Triangle>();

        public static OBJ_JSON loadFromJson(ResourceLocation location) {
            OBJ_JSON obj;
            try {
                int c;
                Object str = "";
                Resource resource = (Resource)Minecraft.m_91087_().m_91098_().m_213713_(location).get();
                InputStreamReader isr = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);
                while ((c = isr.read()) != -1) {
                    str = (String)str + (char)c;
                }
                Gson gson = new Gson();
                obj = (OBJ_JSON)gson.fromJson((String)str, new TypeToken<OBJ_JSON>(){}.getType());
                for (int i = 0; i < obj.Face.size(); ++i) {
                    obj.Face.get(i).UpdateNormal(obj.Positions);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return obj;
        }

        public static class Triangle {
            public int x;
            public int y;
            public int z;
            public vec3f Normal;

            public void UpdateNormal(List<vec3f> pos) {
                Vector3f p1 = pos.get(this.x - 1).toBugJumpFormat();
                Vector3f p2 = pos.get(this.y - 1).toBugJumpFormat();
                Vector3f p3 = pos.get(this.z - 1).toBugJumpFormat();
                p1.sub((Vector3fc)p2);
                p1.normalize();
                p2.sub((Vector3fc)p3);
                p2.normalize();
                p1.cross((Vector3fc)p2);
                p1.normalize();
                this.Normal = new vec3f(p1.x(), p2.y(), p3.z());
            }
        }

        public static class vec3f {
            public float x;
            public float y;
            public float z;

            public vec3f(float x, float y, float z) {
                this.x = x;
                this.y = y;
                this.z = z;
            }

            public Vector3f toBugJumpFormat() {
                return new Vector3f(this.x, this.y, this.z);
            }
        }
    }
}

